% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_asset}
\alias{add_asset}
\title{Adds an Asset to the Thot project.
The associated data should be saved at the return path.}
\usage{
add_asset(
  db,
  file,
  name = NULL,
  type = NULL,
  description = NULL,
  tags = list(),
  metadata = list()
)
}
\arguments{
\item{db}{Thot database connection.}

\item{file}{File name of the associated data.
Use relative paths to place the Asset in a bucket.}

\item{name}{Name of the Asset.}

\item{type}{Type of the Asset.}

\item{description}{Description of the Asset.}

\item{tags}{List of tags for the Asset.}

\item{metadata}{Named list of metadata for the Asset.}
}
\value{
Path to save the Asset's related data to.
}
\description{
Adds an Asset to the Thot project.
The associated data should be saved at the return path.
}
\examples{
db <- database()
path <- add_asset(db, "my_file.txt", name = "My Text File")
cat("Hello!", path)
}
